%------------------------------------------------------------------------------
% File     : SYO063^4 : TPTP v7.4.0. Released v4.0.0.
% Domain   : Logic Calculi (Intuitionistic logic)
% Problem  : ILTP Problem SYJ106+1
% Version  : [Goe33] axioms.
% English  :

% Refs     : [Goe33] Goedel (1933), An Interpretation of the Intuitionistic
%          : [Gol06] Goldblatt (2006), Mathematical Modal Logic: A View of
%          : [ROK06] Raths et al. (2006), The ILTP Problem Library for Intu
%          : [Ben09] Benzmueller (2009), Email to Geoff Sutcliffe
%          : [BP10]  Benzmueller & Paulson (2009), Exploring Properties of
% Source   : [Ben09]
% Names    : SYJ106+1 [ROK06]

% Status   : Theorem
% Rating   : 0.57 v7.4.0, 0.67 v7.2.0, 0.62 v7.1.0, 0.75 v7.0.0, 0.71 v6.4.0, 0.67 v6.3.0, 0.80 v6.2.0, 0.86 v5.5.0, 0.83 v5.4.0, 0.80 v5.2.0, 1.00 v4.0.0
% Syntax   : Number of formulae    :   49 (   0 unit;  25 type;  19 defn)
%            Number of atoms       :  148 (  19 equality;  48 variable)
%            Maximal formula depth :   10 (   5 average)
%            Number of connectives :   89 (   3   ~;   1   |;   2   &;  81   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  100 ( 100   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   28 (  25   :;   0   =)
%            Number of variables   :   40 (   1 sgn;   7   !;   2   ?;  31   ^)
%                                         (  40   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This is an ILTP problem embedded in TH0
%------------------------------------------------------------------------------
include('Axioms/LCL010^0.ax').
%------------------------------------------------------------------------------
thf(p_type,type,(
    p: $i > $o )).

thf(q_type,type,(
    q: $i > $o )).

thf(r_type,type,(
    r: $i > $o )).

thf(s_type,type,(
    s: $i > $o )).

thf(t_type,type,(
    t: $i > $o )).

thf(axiom1,axiom,
    ( ivalid @ ( iatom @ s ) )).

thf(axiom2,axiom,
    ( ivalid @ ( iimplies @ ( inot @ ( iimplies @ ( iatom @ t ) @ ( iatom @ r ) ) ) @ ( iatom @ p ) ) )).

thf(con,conjecture,
    ( ivalid @ ( iimplies @ ( inot @ ( iand @ ( iimplies @ ( iatom @ p ) @ ( iatom @ q ) ) @ ( iimplies @ ( iatom @ t ) @ ( iatom @ r ) ) ) ) @ ( iand @ ( inot @ ( inot @ ( iatom @ p ) ) ) @ ( iand @ ( iatom @ s ) @ ( iatom @ s ) ) ) ) )).

%------------------------------------------------------------------------------
